/* <nagc06.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library c06 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2143 (Feb 1998).
 * Mark 6 revised. IER-3025 (July 2000).
 */
#ifndef NAGC06
#define NAGC06

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* The following defines are for stringents only */
#define NUMFAC 20   /* Limit on number of prime factors in n, used in c06eac,    */
  /* c06ebc, c06ecc, c06ekc. To test error exits in stringents */
  /* NUMFAC may need to be set to a value of 9 or less as      */
  /* array sizes to test n with 20 or more factors may be      */
  /* too large for compiler.                                   */
  /* (n with 20 factors is at least 1048576)                   */
#define C06_STRINGENT_SIZE 1024  /* Array size for stringent programs c06eac,    */
  /* c06ecc, c06ekc. Change for values of n       */
  /* larger than 1024. If set lower than 1024     */
  /* amend data file to remove values of n higher */
  /* than C06_STRINGENT_SIZE.                     */
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL c06eac(Integer pts, double x[], NagError *fail);
  extern void c06eaf_f(double x[], Integer pts, Integer *ifail);
  extern void c06eaq(double *x, Integer pts, Integer m, Integer p);
  extern void c06eaq_f(double x[], Integer pts, Integer m, Integer p);
  extern void c06ear(double *x0, Integer pts, double *x1, Integer m1, double *x2,
                     Integer m2, double *x3, Integer m3, double *x4, Integer m4,
                     double *x5, Integer m5, double *x6, Integer m6, double *x7,
                     Integer m7, Integer m);
  extern void c06ear_f(double x0[], Integer pts, double x1[], Integer m1,
                       double x2[], Integer m2, double x3[], Integer m3,
                       double x4[], Integer m4, double x5[], Integer m5,
                       double x6[], Integer m6, double x7[], Integer m7,
                       Integer m);
  extern void c06eas(double *x0, Integer pts, double *x1, Integer m1, double *x2, Integer m2,
                     double *x3, Integer m3, double *x4, Integer m4, Integer m);
  extern void c06eas_f(double x0[], Integer pts, double x1[], Integer m1,
                       double x2[], Integer m2, double x3[], Integer m3,
                       double x4[], Integer m4, Integer m);
  extern void c06eat(double *x0, Integer pts, double *x1, Integer m1, double *x2,
                     Integer m2, double *x3, Integer m3, Integer m);
  extern void c06eat_f(double x0[], Integer pts, double x1[], Integer m1,
                       double x2[], Integer m2, double x3[], Integer m3,
                       Integer m);
  extern void c06eau(double *x0, Integer pts, double *x1, Integer m1, double *x2,
                     Integer m2, Integer m);
  extern void c06eau_f(double x0[], Integer pts, double x1[], Integer m1,
                       double x2[], Integer m2, Integer m);
  extern void c06eav(double *x0, Integer pts, double *x1, Integer m1, Integer m);
  extern void c06eav_f(double x0[], Integer pts, double x1[], Integer m1,
                       Integer m);
  extern void c06eaw(double *x, Integer pts, Integer *factor);
  extern void c06eaw_f(double x[], Integer pts, const Integer factor[]);
  extern void c06eax(double *x, Integer pts, Integer *sym);
  extern void c06eax_f(double x[], Integer pts, const Integer sym[]);
  extern void c06eay(double *x, Integer pts, Integer *sym, Integer psym, Integer *unsym);
  extern void c06eay_f(double x[], Integer pts, const Integer sym[], Integer psym,
                       const Integer unsym[]);
  extern void c06eaz(Integer pts, Integer pmax, Integer twogrp, Integer *factor, Integer *sym,
                     Integer *psym, Integer *unsym, NagError *error);
  extern void c06eaz_f(Integer pts, Integer pmax, Integer twogrp, Integer factor[],
                       Integer sym[], Integer *psym, Integer unsym[], Integer *ierror);
  extern NAG_DLL_EXPIMP void NAG_CALL c06ebc(Integer pts, double x[], NagError *fail);
  extern void c06ebf_f(double x[], Integer pts, Integer *ifail);
  extern void c06ebq(double *x, Integer pts, Integer m, Integer p);
  extern void c06ebq_f(double x[], Integer pts, Integer m, Integer p);
  extern void c06ebr(double *x0, Integer pts, double *x1, Integer m1, double *x2, Integer m2,
                     double *x3, Integer m3, double *x4, Integer m4, double *x5, Integer m5,
                     double *x6, Integer m6, double *x7, Integer m7, Integer m);
  extern void c06ebr_f(double x0[], Integer pts, double x1[], Integer m1,
                       double x2[], Integer m2, double x3[], Integer m3,
                       double x4[], Integer m4, double x5[], Integer m5,
                       double x6[], Integer m6, double x7[], Integer m7,
                       Integer m);
  extern void c06ebs(double *x0, Integer pts, double *x1, Integer m1, double *x2,
                     Integer m2, double *x3, Integer m3, double *x4, Integer m4,
                     Integer m);
  extern void c06ebs_f(double x0[], Integer pts, double x1[], Integer m1,
                       double x2[], Integer m2, double x3[], Integer m3,
                       double x4[], Integer m4, Integer m);
  extern void c06ebt(double *x0, Integer pts, double *x1, Integer m1, double *x2,
                     Integer m2, double *x3, Integer m3, Integer m);
  extern void c06ebt_f(double x0[], Integer pts, double x1[], Integer m1,
                       double x2[], Integer m2, double x3[], Integer m3,
                       Integer m);
  extern void c06ebu(double *x0, Integer pts, double *x1, Integer m1, double *x2,
                     Integer m2, Integer m);
  extern void c06ebu_f(double x0[], Integer pts, double x1[], Integer m1,
                       double x2[], Integer m2, Integer m);
  extern void c06ebv(double *x0, Integer pts, double *x1, Integer m1, Integer m);
  extern void c06ebv_f(double x0[], Integer pts, double x1[], Integer m1,
                       Integer m);
  extern void c06ebw(double *x, Integer pts, Integer *factor);
  extern void c06ebw_f(double x[], Integer pts, const Integer factor[]);
  extern NAG_DLL_EXPIMP void NAG_CALL c06ecc(Integer pts, double x[], double y[], NagError *fail);
  extern void c06ecq(double *x, double *y, Integer pts, Integer m, Integer p);
  extern void c06ecr(double *x0, double *y0, Integer pts, double *x1, double *y1,
                     Integer m1, double *x2, double *y2, Integer m2, double *x3,
                     double *y3, Integer m3, double *x4, double *y4, Integer m4,
                     double *x5, double *y5, Integer m5, double *x6, double *y6,
                     Integer m6, double *x7, double *y7, Integer m7, Integer m);
  extern void c06ecs(double *x0, double *y0, Integer pts, double *x1, double *y1,
                     Integer m1, double *x2, double *y2, Integer m2, double *x3,
                     double *y3, Integer m3, double *x4, double *y4, Integer m4,
                     Integer m);
  extern void c06ect(double *x0, double *y0, Integer pts, double *x1, double *y1,
                     Integer m1, double *x2, double *y2, Integer m2, double *x3,
                     double *y3, Integer m3, Integer m);
  extern void c06ecu(double *x0, double *y0, Integer pts, double *x1, double *y1, Integer m1,
                     double *x2, double *y2, Integer m2, Integer m);
  extern void c06ecv(double *x0, double *y0, Integer pts, double *x1, double *y1,
                     Integer m1, Integer m);
  extern void c06ecw(double *x, double *y, Integer pts, Integer *factor);
  extern void c06ecx(double *x, double *y, Integer pts, Integer *sym);
  extern void c06ecy(double *x, double *y, Integer pts, Integer *sym, Integer psym,
                     Integer *unsym);
  extern NAG_DLL_EXPIMP void NAG_CALL c06ekc(Nag_VectorOp Operation, Integer n, double x[], double y[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06fpc(Integer m, Integer n, double x[], double trig[], NagError *fail);
  extern void c06fpr(double *a, double *b, Integer p, Integer q, Integer r,
                     double *cosine, double *sine);
  extern void c06fps(double *a, double *b, Integer p, Integer r, double *cosine,
                     double *sine);
  extern void c06fpt(double *a, double *b, Integer p, Integer r, double *cosine,
                     double *sine);
  extern void c06fpu(double *a, double *b, Integer p, Integer r, double *cosine,
                     double *sine);
  extern void c06fpv(double *a, double *b, Integer p, Integer r, double *cosine,
                     double *sine);
  extern void c06fpw(double *a, double *b, Integer p, Integer r, double *cosine,
                     double *sine);
  extern void c06fpx(double *a, Integer m, Integer n, Integer *q, Integer nq,
                     double *trig, int *localerror);
  extern NAG_DLL_EXPIMP void NAG_CALL c06fpz(Integer n, Integer *nq, Integer *q);
  extern NAG_DLL_EXPIMP void NAG_CALL c06fqc(Integer m, Integer n, double x[], double trig[], NagError *fail);
  extern void c06fqq(double *a, Integer m, Integer n);
  extern void c06fqr(double *a, double *b, Integer p, Integer q, Integer r,
                     double *cosine, double *sine);
  extern void c06fqs(double *a, double *b, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06fqt(double *a, double *b, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06fqu(double *a, double *b, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06fqv(double *a, double *b, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06fqw(double *a, double *b, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06fqx(double *a, Integer m, Integer n, Integer *q, Integer nq,
                     double *trig, int *localerror);
  extern NAG_DLL_EXPIMP void NAG_CALL c06frc(Integer m, Integer n, double x[], double y[], double trig[],
                                             NagError *fail);
  extern void c06frr(double *x, double *y, double *br, double *bi, Integer p, Integer q,
                     Integer r, double *cosine, double *sine);
  extern void c06frs(double *x, double *y, double *br, double *bi, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06frt(double *x, double *y, double *br, double *bi, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06fru(double *x, double *y, double *br, double *bi, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06frv(double *x, double *y, double *br, double *bi, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06frw(double *x, double *y, double *br, double *bi, Integer p, Integer r,
                     double *cosine, double *sine);
  extern void c06frx(double *x, double *y, Integer m, Integer n, Integer *q, Integer nq,
                     double *trig, int *localerror);
  extern NAG_DLL_EXPIMP void NAG_CALL c06fuc(Integer m, Integer n, double x[], double y[], double trigm[],
                                             double trign[], NagError *fail);
  extern void c06fuz(double *x, double *y, double *xx, double *yy, Integer m, Integer n);
  extern NAG_DLL_EXPIMP void NAG_CALL c06gbc(Integer n, double x[], NagError *fail);
  extern void c06gbf_f(double x[], Integer pts, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06gcc(Integer n, double y[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06gqc(Integer m, Integer n, double x[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06gsc(Integer m, Integer n, double x[], double u[], double v[],
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06gzc(Integer n, double trig[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06hac(Integer m, Integer n, double x[],
                                             double trig[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06hbc(Integer m, Integer n, double x[],
                                             double trig[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06hcc(Nag_TransformDirection direct, Integer m, Integer n, double x[],
                                             double trig[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06hdc(Nag_TransformDirection direct, Integer m, Integer n, double x[],
                                             double trig[], NagError *fail);
  //Cheney change Complex to complex  2006-6-6
 /* extern NAG_DLL_EXPIMP void NAG_CALL c06pfc(Nag_TransformDirection direct,
                                             Integer ndim, Integer l,
                                             const Integer nd[], Integer n,
                                             Complex x[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06pjc(Nag_TransformDirection direct,
                                             Integer ndim, const Integer nd[],
                                             Integer n, Complex x[],
                                             NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL c06pxc(Nag_TransformDirection direct,
                                           Integer n1, Integer n2, Integer n3,
                                           Complex x[], NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL c06pfc(Nag_TransformDirection direct,
                                             Integer ndim, Integer l,
                                             const Integer nd[], Integer n,
                                             complex x[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL c06pjc(Nag_TransformDirection direct,
                                             Integer ndim, const Integer nd[],
                                             Integer n, complex x[],
                                             NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL c06pxc(Nag_TransformDirection direct,
                                           Integer n1, Integer n2, Integer n3,
                                           complex x[], NagError *fail);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGC06 */
